/*
 * Copyright 2005-2012 Edscott Wilson Garcia 
 * license: GPL v.3
 */

#define __RFM_FGR_C__
#include  "config.h"



#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "rodent.h"

#ifdef ICONVIEW_BINARY
# include "gridview_lib.h"
#endif
#ifdef DESKVIEW_BINARY
# include "deskview_lib.h"
#endif

#define FORCE_CORE
#ifdef FORCE_CORE
# include <sys/time.h>
# include <sys/resource.h>
#endif

#include "find-module.h"
#include "find-module_gui.h"
int
main (int argc, char *argv[]) {
#if GTK_MAJOR_VERSION==2
    if (rfm_gtk_version() != 2)
#else
    if (rfm_gtk_version() != 3)
#endif
	g_error("Critical error. Librfm is compiled for gtk+%d.0 You need to reconfigure and compile to match gtk versions.\n", rfm_gtk_version());


     if(!g_module_supported ()) {
        g_error ("g_module_supported() != TRUE\n");
        exit (1);
    }
     /***************************************************/
    {
        gchar *dir = g_strconcat ("rfm", G_DIR_SEPARATOR_S, "plugins", NULL);
        rfm_set_plugin_dir(LIBDIR, dir);
        g_free(dir);
    }
    /* start loading required dynamic libraries here... */
#ifdef ENABLE_NLS
    /* this binds rfm domain: */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);

    bindtextdomain ("librfm", PACKAGE_LOCALE_DIR);
    bindtextdomain ("rodent", PACKAGE_LOCALE_DIR);
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset ("librfm", "UTF-8");
    bind_textdomain_codeset ("rodent", "UTF-8");
# endif
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    TRACE ("binding %s, at %s", GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
# endif
#endif
    /* g_thread_supported is geeky. returns true if g_threads are already 
     * initialized, not whether they are supported on the current platform! */
    if(!g_thread_supported ())
        rfm_thread_init (NULL);
    rfm_init();
    rodent_init();    

    TRACE ("call to setlocale");
    setlocale (LC_ALL, "");
    TRACE ("call to gtk_init");
    gtk_init (&argc, &argv);
    
    do_find_standalone(argv[1]);
    //rfm_natural(RFM_MODULE_DIR, "fgr", argv[1], "do_find_standalone"); 


    //gtk_main ();
    return 0;
}
