/*
  sfc - a oriented MIDI router 

  sinte.C  -  Sinte Int and Functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/



#include "SFSmi.h"
#include <stdio.h>
#include <string.h>
pthread_mutex_t mutex;
int Pexitprogram, vumvum, espera, UndoCount, programa, hubofile;
const char *FilePreset;
VumetrosIn vumi[3];
VumetrosOut vumo[8];



SFS::SFS ()
{

 int i,j,k;
  //inicio de variables
  propchan=1;
  numeroIN = 1;
  numeroOUT = 1;
  espera = 0;
  UndoCount = 0;
  for (i = 1; i <= 8; i++)
    {
      onoff[i] = 0;
      chout[i] = i;
      oct[i] = 0;
      transp[i] = 0;
      velo[i] = 0;
      startp[i] = 0;
      endp[i] = 108;
      reverb[i] = 0;
      chorus[i] = 0;
      progch[i] = 0;
      BankMSB[i] = 0;
      BankLSB[i] = 0;
      pan[i] = 64;
      volume[i] = 100;
      Pon[i] = 0;
      Ptime[i] = 0;
      PBon[i] = 1;
      EXon[i] = 1;
      MOon[i] = 1;
      MidiInPuerto[1].IN[i] = 1;
      MidiInPuerto[2].IN[i] = 0;
      MidiOutPuerto[1].OUT[i] = 1;
      for (k = 2; k <= 6; k++)
	MidiOutPuerto[k].OUT[i] = 0;

    }
  for (i = 0; i <= 24; i++)
    Cname[i] = 0;
  for (i = 0; i <= 256; i++)
    Comment[i] = 0;

//Inicia Undo

  for (j = 0; j <= 96; j++)
    {
      for (i = 1; i <= 8; i++)
	{
	  Undo[j].onoff[i] = 0;
	  Undo[j].chout[i] = i;
	  Undo[j].oct[i] = 0;
	  Undo[j].transp[i] = 0;
	  Undo[j].velo[i] = 0;
	  Undo[j].startp[i] = 0;
	  Undo[j].endp[i] = 108;
	  Undo[j].reverb[i] = 0;
	  Undo[j].chorus[i] = 0;
	  Undo[j].progch[i] = 0;
	  Undo[j].BankMSB[i] = 0;
	  Undo[j].BankLSB[i] = 0;
	  Undo[j].pan[i] = 64;
	  Undo[j].volume[i] = 100;
	  Undo[j].Pon[i] = 0;
	  Undo[j].Ptime[i] = 0;
	  Undo[j].PBon[i] = 1;
	  Undo[j].EXon[i] = 1;
	  Undo[j].MOon[i] = 1;
	  Undo[j].MidiInPuerto[1].IN[i] = 1;
	  Undo[j].MidiInPuerto[2].IN[i] = 0;
	  Undo[j].MidiOutPuerto[1].OUT[i] = 1;
	  for (k = 2; k <= 6; k++)
	    Undo[j].MidiOutPuerto[k].OUT[i] = 0;


	}

      for (i = 0; i <= 24; i++)
	Undo[j].Cname[i] = 0;
      for (i = 0; i <= 256; i++)
	Undo[j].Comment[i] = 0;

    }


//Inicia Prim

  for (j = 0; j <= 1; j++)
    {
      for (i = 1; i <= 8; i++)
	{
	  Prim[j].onoff[i] = 0;
	  Prim[j].chout[i] = i;
	  Prim[j].oct[i] = 0;
	  Prim[j].transp[i] = 0;
	  Prim[j].velo[i] = 0;
	  Prim[j].startp[i] = 0;
	  Prim[j].endp[i] = 108;
	  Prim[j].reverb[i] = 0;
	  Prim[j].chorus[i] = 0;
	  Prim[j].progch[i] = 0;
	  Prim[j].BankMSB[i] = 0;
	  Prim[j].BankLSB[i] = 0;
	  Prim[j].pan[i] = 64;
	  Prim[j].volume[i] = 100;
	  Prim[j].Pon[i] = 0;
	  Prim[j].Ptime[i] = 0;
	  Prim[j].PBon[i] = 1;
	  Prim[j].EXon[i] = 1;
	  Prim[j].MOon[i] = 1;
	  Prim[j].MidiInPuerto[1].IN[i] = 1;
	  Prim[j].MidiInPuerto[2].IN[i] = 0;
	  Prim[j].MidiOutPuerto[1].OUT[i] = 1;
	  for (k = 2; k <= 6; k++)
	    Prim[j].MidiOutPuerto[k].OUT[i] = 0;

	}

      for (i = 0; i <= 24; i++)
	Prim[j].Cname[i] = 0;
      for (i = 0; i <= 256; i++)
	Prim[j].Comment[i] = 0;

    }



// Inicia BanK

  for (j = 1; j <= 44; j++)
    {

      for (i = 1; i <= 8; i++)
	{

	  Banco[j].onoff[i] = 0;
	  Banco[j].chout[i] = i;
	  Banco[j].oct[i] = 0;
	  Banco[j].transp[i] = 0;
	  Banco[j].velo[i] = 0;
	  Banco[j].startp[i] = 0;
	  Banco[j].endp[i] = 108;
	  Banco[j].reverb[i] = 0;
	  Banco[j].chorus[i] = 0;
	  Banco[j].progch[i] = 0;
	  Banco[j].BankMSB[i] = 0;
	  Banco[j].BankLSB[i] = 0;
	  Banco[j].pan[i] = 64;
	  Banco[j].volume[i] = 100;
	  Banco[j].Pon[i] = 0;
	  Banco[j].Ptime[i] = 0;
	  Banco[j].PBon[i] = 1;
	  Banco[j].EXon[i] = 1;
	  Banco[j].MOon[i] = 1;
	  Banco[j].MidiInPuerto[1].IN[i] = 1;
	  Banco[j].MidiInPuerto[2].IN[i] = 0;
	  Banco[j].MidiOutPuerto[1].OUT[i] = 1;
	  for (k = 2; k <= 6; k++)
	    Banco[j].MidiOutPuerto[k].OUT[i] = 0;

	}


      for (i = 0; i <= 24; i++)
	Banco[j].Cname[i] = 0;
      for (i = 0; i <= 256; i++)
	Banco[j].Comment[i] = 0;


    }



  //ALSA init
  for (i = 1; i <= 2; i++)
    snd_seq_open (&MidiInPuerto[i].midi_in, "default", SND_SEQ_OPEN_INPUT, 0);
  for (i = 1; i <= 6; i++)
    snd_seq_open (&MidiOutPuerto[i].midi_out, "default", SND_SEQ_OPEN_OUTPUT,
		  0);


  int alsaport = 0;
  char portname[50];
  for (i = 1; i <= 2; i++)
    {
      sprintf (portname, "SoundFontCombi IN%d", i);

      alsaport =
	snd_seq_create_simple_port (MidiInPuerto[i].midi_in, portname,
				    SND_SEQ_PORT_CAP_WRITE |
				    SND_SEQ_PORT_CAP_SUBS_WRITE,
				    SND_SEQ_PORT_TYPE_SYNTH);
    }
  for (i = 1; i <= 6; i++)
    {
      sprintf (portname, "SoundFontCombi OUT%d", i);


      alsaport =
	snd_seq_create_simple_port (MidiOutPuerto[i].midi_out, portname,
				    SND_SEQ_PORT_CAP_READ |
				    SND_SEQ_PORT_CAP_SUBS_READ,
				    SND_SEQ_PORT_TYPE_SYNTH);

    }




  FILE *fs;
  char temp[256];
  char nomfile[256];
  sprintf (nomfile, "%s%s", getenv ("HOME"), "/.sfc");
  if ((fs = fopen (nomfile, "r")) != NULL)
	{
	  for (j = 1; j <= 2; j++)
	    {
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      for (i = 0; i <= (int) strlen (temp) - 2; i++)
		MidiInPuerto[j].SetMidiIn[i] = temp[i];
	      MidiInPuerto[j].SMidiIn = MidiInPuerto[j].SetMidiIn;
	    }
	  for (j = 1; j <= 6; j++)
	    {
	      bzero (temp, sizeof (temp));
	      fgets (temp, sizeof temp, fs);
	      for (i = 0; i <= (int) strlen (temp) - 2; i++)
		MidiOutPuerto[j].SetMidiOut[i] = temp[i];
	      MidiOutPuerto[j].SMidiOut = MidiOutPuerto[j].SetMidiOut;
	    }
              bzero(BankFilename, sizeof (BankFilename));
              bzero (temp, sizeof (temp));
              fgets (temp, sizeof temp, fs);
              if (strlen(temp)>2)
               {
                for (i = 0; i <= (int) strlen(temp) - 2; i++) BankFilename[i] = temp[i];
                loadbank(BankFilename);
               }
	}
    

  espera = 1;


};

SFS::~SFS ()
{
int i;
  for (i = 1; i <= 2; i++)
    snd_seq_close (MidiInPuerto[i].midi_in);
  for (i = 1; i <= 6; i++)
    snd_seq_close (MidiOutPuerto[i].midi_out);

};


void
SFS::nuevo ()
{
int i,k;

  for (i = 1; i <= 8; i++)
    {
      onoff[i] = 0;
      chout[i] = i;
      oct[i] = 0;
      transp[i] = 0;
      velo[i] = 0;
      startp[i] = 0;
      endp[i] = 108;
      reverb[i] = 0;
      chorus[i] = 0;
      Pon[i] = 0;
      Ptime[i] = 0;
      progch[i] = 0;
      BankMSB[i] = 0;
      BankLSB[i] = 0;
      pan[i] = 64;
      volume[i] = 100;
      PBon[i] = 1;
      EXon[i] = 1;
      MOon[i] = 1;
      MidiInPuerto[1].IN[i] = 1;
      MidiInPuerto[2].IN[i] = 0;
      MidiOutPuerto[1].OUT[i] = 1;
      for (k = 2; k <= 6; k++)
	MidiOutPuerto[k].OUT[i] = 0;


    }

  for (i = 0; i <= 24; i++)
    Cname[i] = 0;
  Combiname = Cname;
  for (i = 0; i <= 256; i++)
    Comment[i] = 0;
  Comentario = Comment;

};


int
SFS::mirabanco(int i)
{
 
 if (BankMSB[i] >= BankLSB[i]) return(BankMSB[i]);
 return(BankLSB[i]);


};

