/*
  sfc - a oriented MIDI router 

  sfsMidiIn.C  -  MIDI Input functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#include "SFSmi.h"


void
SFS::midievents (int keIN)
{
  int i,j;

  snd_seq_event_t *midievent;
  midievent = NULL;
  snd_seq_event_input (MidiInPuerto[keIN].midi_in, &midievent);
  if (midievent == NULL) return;
  if ((midievent->type == SND_SEQ_EVENT_NOTEON)
      || (midievent->type == SND_SEQ_EVENT_NOTEOFF))
    {
      
      unsigned int cmdchan = midievent->data.note.channel;
      unsigned int cmdnote = midievent->data.note.note;
      unsigned int cmdvelo = midievent->data.note.velocity;
      
      vumi[keIN].ulvum = vumi[keIN].vumvum;
      vumi[keIN].vumvum = cmdvelo;
      
      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);
      for (i = 1; i <= 8; i++)
	{
	  if ((onoff[i]) && ((cmdchan - propchan + 1) == 0 ))
	    {
	      if ((cmdnote >= startp[i]) && (cmdnote <= endp[i]))
		{
		  midievent->data.note.channel = chout[i] - 1;
		  int cmdn = cmdnote;




		  cmdn += ((oct[i] * 12) + transp[i]);
		  if (cmdn > 127)
		    cmdn = 127;
		  if (cmdn < 0)
		    cmdn = 0;
		  midievent->data.note.note = cmdn;
		  if (cmdvelo != 0)
		    {
		      int cmdv = cmdvelo;
		      cmdv += velo[i];
		      if (cmdv > 127)
			cmdv = 127;
		      if (cmdv < 0)
			cmdv = 0;
		      midievent->data.note.velocity = cmdv;
		    }
		  for (j = 1; j <= 6; j++)
		    {
		      if ((MidiInPuerto[keIN].IN[i] == 1)
			  && (MidiOutPuerto[j].OUT[i] == 1))
			{
			  snd_seq_event_output_direct (MidiOutPuerto[j].
						       midi_out, midievent);
			  vumo[j].uvo = midievent->data.note.velocity;
			}
		    }
		}
	    }
	}


    };

  if ((midievent->type == SND_SEQ_EVENT_CHANPRESS)
      || (midievent->type == SND_SEQ_EVENT_PITCHBEND)
      || (midievent->type == SND_SEQ_EVENT_CONTROLLER))
    {

      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);
      
      for (i = 1; i <= 8; i++)
	{
	  if ((onoff[i]) && ((midievent->data.control.channel - propchan + 1) == 0 ))
	    {
	      switch (midievent->type)
		{
		case SND_SEQ_EVENT_PITCHBEND:
		  if (PBon[i] == 0)
		    break;
		case SND_SEQ_EVENT_CONTROLLER:
		  if ((midievent->data.control.param == 1) && (MOon[i] == 0))
		    break;
		  if ((midievent->data.control.param == 64) && (EXon[i] == 0))
		    break;

		  midievent->data.control.channel = chout[i] - 1;
		  for (j = 1; j <= 6; j++)
		    {
		      if ((MidiInPuerto[keIN].IN[i] == 1)
			  && (MidiOutPuerto[j].OUT[i] == 1))
			snd_seq_event_output_direct (MidiOutPuerto[j].
						     midi_out, midievent);
		    }
		  break;

		default:
		  midievent->data.control.channel = chout[i] - 1;
		  for (j = 1; j <= 6; j++)
		    {
		      if ((MidiInPuerto[keIN].IN[i] == 1)
			  && (MidiOutPuerto[j].OUT[i] == 1))
			snd_seq_event_output_direct (MidiOutPuerto[j].
						     midi_out, midievent);
		    }
		}




	    }
	}
    };

  if (midievent->type == SND_SEQ_EVENT_PGMCHANGE)

    {
      if ((midievent->data.control.channel == (propchan-1)) && (midievent->data.control.value > 0) && (midievent->data.control.value < 45)) 

       {
            programa = midievent->data.control.value;
            return;
       }     
          
       
     }


/*
   if (midievent->type == SND_SEQ_EVENT_SYSEX)
   
     {
     
     
     
     
     
     
     }

*/

};
