/*
  sfc - a oriented MIDI router 

  main.C  -  Main file of the organ
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include <getopt.h>
#include <pthread.h>
#include "SFSmi.h"
#include "SFSUI.h"


pthread_t thr1, thr2, thr3;




SFS sfs;


void *
thread1 (void *arg)
{
  while (Pexitprogram == 0)
    sfs.midievents (1);
  return (0);
};

void *
thread2 (void *arg)
{
  while (Pexitprogram == 0)
    sfs.midievents (2);
  return (0);
};



int main (int argc, char *argv[])

{



  fprintf (stderr,
	   "SoundFontCombi v0.017 - Copyright (c) 2003-2004 Josep Andreu (Holborn)\n");
  if (argc == 1)
    fprintf (stderr, "Try 'sfc --help' for command-line options.\n");

  char NombreTemp[128];
  
  bzero(NombreTemp, sizeof(NombreTemp));

  strcat(NombreTemp, PRESETDIR);
  strcat(NombreTemp ,"GMPresetList.txt");

  FilePreset = strdup(NombreTemp);

  
  struct option opts[] = {
    {"preset", 2, NULL, 'p'},
    {"load", 2, NULL, 'l'},
    {"bank", 2, NULL, 'b'},
    {"help", 2, NULL, 'h'},
    {0, 0, 0, 0}
  };

  Pexitprogram = 0;
  hubofile = 0;

  opterr = 0;
  int option_index = 0, opt, exitwithhelp = 0;
  while (1)
    {
      opt = getopt_long (argc, argv, "p:l:b:h", opts, &option_index);
      char *optarguments = optarg;

      if (opt == -1)
	break;


      switch (opt)
	{
	case 'h':
	  exitwithhelp = 1;
	  break;
	case 'p':
	  if (optarguments != NULL)
	    {
	      FilePreset = optarguments;
	      break;
	    }
	case 'l':
	  if (optarguments != NULL)
	    {
              hubofile = 1;
	      sfs.loadfile (optarguments);
	      break;
	    }
	case 'b':
	  if (optarguments != NULL)
	    {
	      sfs.loadbank (optarguments);
	      break;
	    }


	};
    };

  if (exitwithhelp != 0)
    {
      fprintf (stderr, "Usage: sfc [OPTION]\n\n");
      fprintf (stderr,
	       "  -h ,     --help \t\t\t display command-line help and exit\n");
      fprintf (stderr,
	       "  -p File, --preset=File \t\t get the preset file list\n");
      fprintf (stderr, "  -l File, --load=File \t\t\t loads combi\n");
      fprintf (stderr, "  -b File, --bank=File \t\t\t loads bank\n");
      fprintf (stderr, "\n\n");
      return (0);
    };





// Lee Presets
  int i = 0, j = 0;

  memset(sfs.PresetList, 0 ,sizeof sfs.PresetList);

  for (i = 0; i <= 127; i++)
    {
      for (j = 0; j <= 127; j++)
	{
	  sfs.PresetList[i].Banco = i;
	  sfs.PresetList[i].PBanco[i].Prog = j;
	}
    }
  FILE *fp;
  char temp[256];
  int bb = 0, pp = 0;
  char nn[80];
  if ((fp = fopen (FilePreset, "r")) != NULL)
    {

      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fp) != NULL)
	{
	  sscanf (temp, "%d %d %[^]]c", &bb, &pp, (char*) nn);

	  for (i = 0; i <= (int) strlen(temp); i++)
	    sfs.PresetList[bb].PBanco[pp].ProgName[i] = nn[i];

	}
    };


  SFSUI *sfsUI = new SFSUI (&sfs);


  pthread_mutex_init (&mutex, NULL);
  pthread_create (&thr1, NULL, thread1, NULL);
  pthread_create (&thr2, NULL, thread2, NULL);


  while (Pexitprogram == 0)
    {

      Fl::wait();

      if (vumi[1].vumvum != vumi[1].ulvum)
	sfsUI->VUI1->value (vumi[1].vumvum);

      if (vumi[2].vumvum != vumi[2].ulvum)
	sfsUI->VUI2->value (vumi[2].vumvum);


      if (vumo[1].uluvo != vumo[1].uvo)
	{
	  sfsUI->MO1->value (vumo[1].uvo);
	  vumo[1].uluvo = vumo[1].uvo;
	}
      if (vumo[2].uluvo != vumo[2].uvo)
	{
	  sfsUI->MO2->value (vumo[2].uvo);
	  vumo[2].uluvo = vumo[2].uvo;
	}

      if (vumo[3].uluvo != vumo[3].uvo)
	{
	  sfsUI->MO3->value (vumo[3].uvo);
	  vumo[3].uluvo = vumo[3].uvo;
	}
      if (vumo[4].uluvo != vumo[4].uvo)
	{
	  sfsUI->MO4->value (vumo[4].uvo);
	  vumo[4].uluvo = vumo[4].uvo;
	}


      if (vumo[5].uluvo != vumo[5].uvo)
	{
	  sfsUI->MO5->value (vumo[5].uvo);
	  vumo[5].uluvo = vumo[5].uvo;
	}

      if (vumo[6].uluvo != vumo[6].uvo)
	{
	  sfsUI->MO6->value (vumo[6].uvo);
	  vumo[6].uluvo = vumo[6].uvo;
	}

      if (programa != 0)
	{
	  sfsUI->PutCombi (programa);
	  programa = 0;
	}

    }


  pthread_mutex_destroy (&mutex);
  delete sfsUI;
  exit(0);

};
