#include <string.h>
#include <errno.h>
#include "konforka/exception.h"

namespace konforka {

    /*
     * code_point
     */

    code_point::code_point(const string& w)
	: where(w), line(-1) { }
    code_point::code_point(const string& fi,const string& fu,int l)
	: file(fi), function(fu), line(l) {
	    make_where();
	}

    const char *code_point::c_str() const throw() {
	return where.c_str();
    }

    void code_point::make_where() {
	static char tmp[8];
	snprintf(tmp,sizeof(tmp),"%d",line);
	where = file + ":" + tmp + " [" + function + "]";
    }
    
    /*
     * exception
     */

    exception::exception(const string& whe,const string& wha)
	: _where(whe), _what(wha) { }
    exception::exception(const string& fi,const string& fu,int l,const string& w)
	: _where(fi,fu,l), _what(w) { }
    exception::~exception() throw() { }

    const char *exception::where() const throw() {
	return _where.c_str();
    }
    const char *exception::what() const throw() {
	return _what.c_str();
    }

    void exception::see(const string& w) {
	_seen.push_back(code_point(w));
    }
    void exception::see(const string& fi,const string& fu,int l) {
	_seen.push_back(code_point(fi,fu,l));
    }

    /*
     * system_error
     */

    system_error::system_error(const string& whe,const string& wha)
	: _errno(errno), exception(whe,wha) { }
    system_error::system_error(const string& fi,const string& fu,int l,const string& w)
	: _errno(errno), exception(fi,fu,l,w) { }
    system_error::~system_error() throw() { }

    const char *system_error::why() const throw() {
	return strerror(errno); // TODO: strerror_r
    }

}
