# this plugin creates a buttonbar on a patch window when that patch
# window is in Edit Mode

# this GUI plugin removes the menubars from any patch window that is
# not in Edit Mode.  Also, if a patch is switched to Run Mode, the
# menubar will be removed.

package require base64

proc make_pd_button {mytoplevel name} {
    button $mytoplevel.buttonbar.$name -image buttonimage$name \
        -relief flat -borderwidth 0 -highlightthickness 0 \
        -highlightcolor grey -highlightbackground grey -padx 0 -pady 0 \
        -command "menu_send_float \$::focused_window $name 0"
    pack $mytoplevel.buttonbar.$name -side left -padx 0 -pady 0
}

proc make_iemgui_button {mytoplevel name} {
    button $mytoplevel.buttonbar.$name -image buttonimage$name \
        -relief sunken -borderwidth 0 -highlightthickness 0 \
        -highlightcolor grey -highlightbackground grey -padx 0 -pady 0 \
        -command "menu_send \$::focused_window $name"
    pack $mytoplevel.buttonbar.$name -side left -padx 0 -pady 0
}

proc showhide_buttonbar {mytoplevel} {
    if { ! [winfo exists $mytoplevel.buttonbar]} {
        frame $mytoplevel.buttonbar -cursor arrow -background grey \
            -pady 0
        make_pd_button $mytoplevel obj
        make_pd_button $mytoplevel msg
        make_pd_button $mytoplevel floatatom
        make_pd_button $mytoplevel symbolatom
        make_pd_button $mytoplevel text
        make_iemgui_button $mytoplevel bng
        make_iemgui_button $mytoplevel toggle
        make_iemgui_button $mytoplevel numbox
        make_iemgui_button $mytoplevel hslider
        make_iemgui_button $mytoplevel vslider
        make_iemgui_button $mytoplevel hradio
        make_iemgui_button $mytoplevel vradio
        make_iemgui_button $mytoplevel vumeter        
        make_iemgui_button $mytoplevel mycnv
        make_iemgui_button $mytoplevel menuarray
    }
    if {$::editmode($mytoplevel)} {
        set tkcanvas [tkcanvas_name $mytoplevel]
        pack forget $tkcanvas
        pack $mytoplevel.buttonbar -side top -fill x
        pack $tkcanvas -side top -expand 1 -fill both
    } else {
        pack forget $mytoplevel.buttonbar
    }
}

bind PatchWindow <FocusIn> {+showhide_buttonbar %W}
bind PatchWindow <<EditMode>> {+showhide_buttonbar %W}

#set imgdir "/Users/hans/Desktop/buttonbar"
#image create photo buttonimageobj -file $imgdir/obj.gif.pgm
#image create photo buttonimagemsg -file $imgdir/msg.gif.pgm
#image create photo buttonimagefloatatom -file $imgdir/floatatom.gif
#image create photo buttonimagesymbolatom -file $imgdir/symbolatom.gif
#image create photo buttonimagetext -file $imgdir/text.gif

#image create photo buttonimagebng -file $imgdir/bng.gif
#image create photo buttonimagetoggle -file $imgdir/toggle.gif
#image create photo buttonimagenumbox -file $imgdir/numbox.gif
#image create photo buttonimagehslider -file $imgdir/hslider.gif.pgm
#image create photo buttonimagevslider -file $imgdir/vslider.gif.pgm
#image create photo buttonimagehradio -file $imgdir/hradio.gif.pgm
#image create photo buttonimagevradio -file $imgdir/vradio.gif.pgm
#image create photo buttonimagevumeter -file $imgdir/vumeter.gif
#image create photo buttonimagemycnv -file $imgdir/mycnv.gif

#image create photo buttonimagemenuarray -file $imgdir/array.gif

set menuarraydata {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}
image create photo buttonimagemenuarray -data $menuarraydata

set bngdata {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ctgonSeatqy7sqqIznTShG8Elt/mia06k9wlVYS8WAUAOw==
}
image create photo buttonimagebng -data $bngdata

set floatatomdata {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==
}
image create photo buttonimagefloatatom -data $floatatomdata

set hradiodata {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}
image create photo buttonimagehradio -data $hradiodata

set hsliderdata {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}
image create photo buttonimagehslider -data $hsliderdata

set msgdata {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}
image create photo buttonimagemsg -data $msgdata

set mycnvdata {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}
image create photo buttonimagemycnv -data $mycnvdata

set numboxdata {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}
image create photo buttonimagenumbox -data $numboxdata

set objdata {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}
image create photo buttonimageobj -data $objdata

set symbolatomdata {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==
}
image create photo buttonimagesymbolatom -data $symbolatomdata

set textdata {
R0lGODlhGwARAPAAAP///wAAACH5BAAAAAAAIf8LSUNDUkdCRzEwMTL/AAAPhGFwcGwCAAAAbW50
clJHQiBYWVogB9oACQABAA8AEwAfYWNzcEFQUEwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPbW
AAEAAAAA0y1hcHBs2S6BsfMyXumJcebqTFAPNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAOclhZWgAAASwAAAAUZ1hZWgAAAUAAAAAUYlhZWgAAAVQAAAAUd3RwdAAAAWgAAAAUY2hhZAAA
AXwAAAAsclRSQwAAAagAAAAOZ1RSQwAAAbgAAAAOYlRSQwAAAcgAAAAOdmNndAAAAdgAAAYSbmRp
bgAAB+wAAAY+ZGVz/2MAAA4sAAAAZGRzY20AAA6QAAAApm1tb2QAAA84AAAAKGNwcnQAAA9gAAAA
JFhZWiAAAAAAAABhCgAAOFEAAAdYWFlaIAAAAAAAAHBLAACwcwAAIo9YWVogAAAAAAAAJYEAABdX
AACpPlhZWiAAAAAAAADzUgABAAAAARbPc2YzMgAAAAAAAQxCAAAF3v//8yYAAAeSAAD9kf//+6L/
//2jAAAD3AAAwGxjdXJ2AAAAAAAAAAEBzQAAY3VydgAAAAAAAAABAc0AAGN1cnYAAAAAAAAAAQHN
AAB2Y2d0AAAAAAAAAAAAAwEAAAIAAAAdAGUA0gF8AkoDHgQIBSMGXP8HsgkkCrMMXQ4OD9MRnhNl
FSwW7RieGkQb3x1rHu4gYyHOIzEkiSXfJzEofSnIKw4sUy2TLtAwCTE/Mm0zlzS8Nd029jgNOR06
KTszPDc9Oj46PzdAM0EuQilDIkQaRRRGDEcER/5I90nvSuhL4UzcTdZO0U/NUMpRyFLHU8dUx1XI
VspXzFjPWdNa11vdXOJd6V7wX/hhAGIJYxNkHmUqZjZnQmhPaVtqaGt2bIRtkm6fb61wunHIctVz
4nTvdfx3B3gSeRx6J3swfDd9P35Ff0qAT4FSglWDVoRXhVeGVodUiFKJUIpNi0qMR41DjkCPPZA7
kTiSN5M2lDWVNZb/Npc3mDmZO5o+m0KcRZ1JnkyfUKBUoViiXKNfpGKlZqZpp2yob6lxqnSrdax3
rXiuea95sHmxeLJ2s3S0cbVutmm3Y7hduVa6TbtDvDm9Lb4fvxDAAMDtwdnCw8OqxI/FccZRxy/I
CsjkybzKkMtkzDXNBc3Tzp/PatAz0PzRwtKH00rUDdTO1YzWStcI18TYftk42fLaqtti3Brc0t2K
3kLe+d+x4GjhIOHY4o/jR+P/5LblbeYl5tznlehP6Qrpx+qI60zsFOzi7bfuku918F/xUfJM80/0
W/Vt9of3p/jN+fj7I/xU/Yr+xP//AAAAHABiAMoBZgIoAucDzgTN/wX2BzUIlAoFC5kNMQ7XEIcS
LxPcFX0XFRikGicbmR0EHl0fsiD/IkcjhSTBJfsnLiheKY0quCvgLQMuIi87ME4xXTJkM2g0ZjVg
NlY3Rzg2OR86CDrvO9M8tz2aPnw/XkA/QSFCAULiQ8NEpEWGRmlHTUgwSRZJ/ErkS81Mt02jTpJP
gFBwUWFSU1NFVDhVK1YeVxBYA1j2Weda2VvLXL1drl6gX5BggWFyYmNjVGRGZThmK2cgaBRpCmoC
avpr9Gzubepu5m/jcOFx33Ldc9t02XXWdtN3z3jMech6wnu8fLZ9rn6nf5+AloGNgoODeoRvhWWG
XIdTiEmJQYo5i/8xjCqNJY4fjxqQFZERkg6TC5QIlQWWApb/l/2Y+pn3mvSb8Jzsneie45/foNqh
1KLOo8ikw6W+prmntaixqa+qrauurK+tsq63r7yww7HLstSz3bTmtfC2+LgBuQm6D7sUvBi9Gr4a
vxjAFcEQwgnDAcP2xOvF3cbPx7/IrcmayoXLcMxYzUDOJs8Lz+/Q0tGz0pPTctRR1S/WDdbr18nY
p9mF2mXbRtwp3Q7d9d7f38zgvOGv4qXjnuSa5Zjmmeeb6J/ppOqq67Hsue3B7srv1PDe8ery9/QE
9RT2Jfc3+Er5YPp3+478pv3A/t3//wAAABYATgCiARIBqQJNAvj/A8cErQWoBrkH3gkXClgLoQzx
DkMPjBDWEhYTThR6FZ4WuBfKGNYZ2hraG9Yczh3DHrYfqCCXIYQibyNXJDwlHSX7JtQnqSh5KUYq
DirRK5EsTi0HLbsuby8gL80weTElMcwydDMbM8A0ZTUKNa42Uzb2N5o4PjjhOYQ6KDrLO288Ejy1
PVg9+j6dP0A/40CGQSlBzUJxQxZDvERjRQtFtEZfRwpHt0hlSRRJw0pzSyVL1kyJTTxN8E6kT1lQ
DlDEUXtSMlLpU6FUWlUSVcxWhVc/V/lYs1ltWiha4ludXFhdE13OXopfRmACYL5he2I5YvdjtWR1
ZTVl92a5Z31o/0JpCGnPaphrYmwtbPhtxW6Tb2FwMHD/cc9yoHNxdEJ1FXXndrp3jnhieTd6DHrh
e7h8j31lfjx/FH/sgMWBnYJ3g1CEKoUEhd6GuYeViHGJTYoqiwiL5ozEjaOOg49kkEaRKJILkvCT
1ZS8laOWjJd2mGCZTJo6myicF50Infue8J/noOGh3aLco9+k5KXspvioB6kYqiyrQ6xbrXauk6+x
sNKx87MWtDq1X7aHt6+42boEuzG8X72QvsO/+sE1wnXDvMUQxm7H2sleyvTMp8580HHSjNTM10DZ
2Nyl35jis+X36Wfs8vB29CP39Pvw//8AAG5kaW4AAAAAAAAGNv8AAJbwAABY6AAAUxgAAIpeAAAn
lwAAFqgAAFANAABUOQACQo8AAfCjAAFrhQADAQAAAgAAABsAMABKAGUAfgCXALAAyQDiAPsBFAEt
AUYBYQF7AZYBsQHOAesCCQIoAkgCaQKMArAC1gL9AyYDUQN+A6wD3QQQBEUEfAS2BPEFLgVtBa4F
8QY1BnwGxAcOB1sHqQf6CE0Iowj8CVgJtgoYCn4K5gtTC8MMNgytDScNpA4lDqgPLg+2EEEQzxFe
EfAShBMZE7EUSxTnFYQWIxbEF2YYChivGVUZ/BqlG1Ab+xypHVceBx64H2sgHiDUIYoiQiL7I7Uk
cSUtJesmqif/aigsKO8ptCp6K0EsCizULaAubi89MA4w4TG1MoszYzQ9NRk1+DbYN7o4nzmHOnA7
XDxLPTw+MD8mQB9BGkIYQxhEG0UgRidHMEg7SUhKV0tnTHhNi06gT7VQy1HjUvtUFFUuVkpXZliE
WaJaw1vkXQdeLF9SYHpho2LPY/xlKmZbZ41owWn3ay9saW2lbuNwI3Flcqpz8XU7dod31nknenx7
030tfop/64FPgreEIoWShwaIf4n9i4CNCo6akDGRz5N0lSCW05iOmk+cGJ3on7+hnaOBpW2nYalb
q12taK95sZGzsLXVuAC6L7xivpjA0sMOxU3Hj8nUzBzOaNC3/9MI1VjXpdns3CneWeB64onkhuZy
6E7qG+vZ7YvvM/DS8mnz+fWE9wr4k/oW+5T9D/6G//8AAAAcADMAUABrAIcAoQC8ANYA8QEMASYB
QQFdAXkBlgGzAdEB8QIRAjICVQJ5Ap8CxgLvAxoDRwN3A6gD3QQTBEwEhwTEBQQFRgWKBdAGGQZk
BrAHAAdRB6UH/AhWCLMJFAl4CeEKTQq+CzMLrAwqDKwNMw29DksO3Q9yEAoQpRFDEeMShxMsE9UU
fxUrFdkWiRc6F+0YoBlVGgsawRt5HDIc7B2oHmUfJB/lIKghbSI0Iv4jyiSYJWgmOycPJ+YowCmb
KngrVyw3Lf8ZLfsu3y/EMKoxkDJ3M180SDUyNhw3CTf2OOU51jrIO708tD2tPqg/pUCmQahCrUO1
RL5Fy0baR+tI/koTSytMRE1eTnpPmFC2UdZS91QZVTtWX1eEWKpZ0Vr5XCNdTl57X6lg2WIKYz5k
c2WrZuRoIGleap1r320jbmlvsXD6ckVzkHTddip3d3jFehJ7X3ysffh/RICRgd2DKoR4hceHF4hq
ib6LFYxujcuPK5CPkfeTY5TTlkeXwJk9mr6cRJ3On1yg7qKFpCClwKdkqQ2quqxsriKv3bGds2G1
Kbb0uMO6lLxnvjvAEMHjw7XFhMdQyRfK28yazlTQC9G+027/1RvWxthw2hjbwd1p3xHgueJi5Azl
tedf6Qjqsexa7gHvqPFP8vT0mPY799/5g/sm/Mf+Zv//AAAAIwBCAGcAiQCrAM0A7wERATMBVgF6
AZ8BxQHsAhYCQQJuAp4C0AMGAz4DewO7A/8ERgSSBOEFNAWKBeQGQQahBwUHbAfXCEcIuwk0CbMK
OArEC1cL8gyUDT8N8g6sD28QORELEeMSwhOmFJAVfxZzF2wYahlsGnMbgByRHacewR/gIQEiJSNL
JHIlmybEJ+4pGipIK3csqC3cLxEwSTGDMr8z/TU+NoA3xTkMOlc7ozzzPkU/m0DzQk5DrEUMRm5H
00k5SqFM/wpNc07dUEdRsVMbVIRV7ldYWMJaLVuZXQZedF/kYVVix2Q6Za9nJWidahVrj20KboZw
BHGEcwR0h3YLd5B5F3qffCl9tH9AgM2CXIPrhXuHDYifijKLxY1YjuyQf5ITk6aVOZbMmF+Z8puE
nRaeqKA5ocijVqTipmyn86l3qvisdq3xr2mw3rJSs8K1MbafuAu5drrgvEq9sr8bwIPB6sNSxLnG
H8eGyOzKUcu2zRvOf8/i0UPSotP+1VfWq9f62UHagdu53OneDN8n4DrhPuI+4y/kHOT95dnmq+d6
6D7pAum56nDrIOvL7HftGO257lju8e+K8CDwsfFD8dPyXf/y6PNz8/j0ffUB9YT2BPaF9wX3iPgK
+I35DfmJ+gb6g/r8+3X77fxm/Nr9Tv3C/jb+qP8a/43//wAAZGVzYwAAAAAAAAAKQ29sb3IgTENE
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAG1sdWMAAAAAAAAABQAAAAxlblVTAAAAEgAAAExmckZSAAAA
EgAAAF5kZURFAAAAEAAAAHBlc0VTAAAAEgAAAIBpdElUAAAAFAAAAJIAQwBvAGwAbwByACAATABD
AEQAyQCTYwByAGEAbgAgAEwAQwBEAEYAYQByAGIALQBMAEMARABMAEMARAAgAGMAbwBsAG8AcgBM
AEMARAAgAGMAbwBsAG8AcgBpAABtbW9kAAAAAAAABhAAAJxhAAAAAMBd/wAAAAAAAAAAAAAAAAAA
AAAAdGV4dAAAAABDb3B5cmlnaHQgQXBwbGUsIEluYy4sIDIwMTAAACwAAAAAGwARAAACMYSPqcvt
D6Oc1IR6V54bhb+B1nGB3UimQKkqnRl6zKvJ9YqjrO6GH5pbnSrEovH4KAAAOw==
}
image create photo buttonimagetext -data $textdata

set toggledata {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}
image create photo buttonimagetoggle -data $toggledata

set vradiodata {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}
image create photo buttonimagevradio -data $vradiodata

set vsliderdata {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}
image create photo buttonimagevslider -data $vsliderdata

set vumeterdata {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}
image create photo buttonimagevumeter -data $vumeterdata

pdtk_post "Finished loading buttonbar-plugin.tcl\n"


